/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core.internal;

import com.aptana.core.resources.IUniformResourceChangeEvent;
import com.aptana.core.resources.IUniformResourceChangeListener;
import com.aptana.core.resources.MarkerUtils;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;

public class UniformResourceBreakpointChangeNotifier
implements IBreakpointManagerListener {
    private ResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    public UniformResourceBreakpointChangeNotifier() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        if (breakpointManager.isEnabled()) {
            this.breakpointManagerEnablementChanged(true);
        }
    }

    public void cleanup() {
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        }
    }

    private void handleResourceChanged(IUniformResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas("org.eclipse.debug.core.lineBreakpointMarker", true);
        if (markerDeltas.length == 0) {
            return;
        }
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return;
        }
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint;
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            int kind = delta.getKind();
            if ((kind == 1 || kind == 2 || kind == 4) && (breakpoint = breakpointManager.getBreakpoint(delta.getMarker())) != null) {
                if (kind == 1) {
                    breakpoint.hashCode();
                } else if (kind == 2) {
                    breakpoint.hashCode();
                } else {
                    breakpointManager.fireBreakpointChanged(breakpoint);
                }
            }
            ++n2;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        if (enabled) {
            MarkerUtils.addResourceChangeListener((IUniformResourceChangeListener)this.resourceChangeListener);
        } else {
            MarkerUtils.removeResourceChangeListener((IUniformResourceChangeListener)this.resourceChangeListener);
        }
    }

    private class ResourceChangeListener
    implements IUniformResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IUniformResourceChangeEvent event) {
            UniformResourceBreakpointChangeNotifier.this.handleResourceChanged(event);
        }
    }
}

